% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_taxa.R
\name{count_taxa}
\alias{count_taxa}
\alias{count_taxa,vegtable,missing-method}
\alias{count_taxa,formula,vegtable-method}
\alias{count_taxa<-}
\alias{count_taxa<-,vegtable,formula-method}
\title{Count taxa included in vegtable objects}
\usage{
\S4method{count_taxa}{vegtable,missing}(object, level, include_lower = FALSE, ...)

\S4method{count_taxa}{formula,vegtable}(
  object,
  data,
  include_lower = FALSE,
  suffix = "_count",
  in_header = TRUE,
  ...
)

count_taxa(data, ...) <- value

\S4method{count_taxa}{vegtable,formula}(data, ...) <- value
}
\arguments{
\item{object}{An object of class \linkS4class{vegtable} or a formula.}

\item{level}{Character value indicating the taxonomic rank of counted taxa.}

\item{include_lower}{Logical value, whether lower taxonomic ranks should be
included at the requested level.}

\item{...}{further arguments passed among methods.}

\item{data}{An object of class \linkS4class{vegtable}.}

\item{suffix}{Character value used as suffix on the calculated variable.}

\item{in_header}{Logical value, whether the result should be included in the
slot header of the input \linkS4class{vegtable} object or not.
A warning message is provided if the calculation is not done for every
plot observation.}

\item{value}{A formula passed to parameter 'object' by the replace method.}
}
\value{
An data frame with the number of taxa from requested level at requested
units for the formula method, or just an integer value.
}
\description{
Counting number of taxa within \linkS4class{taxlist} objects or character vectors
containing taxon names.

This function provides a quick calculation of taxa in \linkS4class{vegtable}
objects, considering only records in slot samples.
Such records can be also merged from lower ranks.

For the formula method, units without any requested taxa will not appear in
the output data frame. If no taxa at all is occurring at the requested level
in any unit, an error message will be retrieved.
}
\examples{
## Different alternatives
count_taxa(Kenya_veg)
head(count_taxa(~ReleveID, Kenya_veg, in_header = FALSE))
head(count_taxa(species ~ ReleveID, Kenya_veg, in_header = FALSE))
head(count_taxa(species ~ ReleveID, Kenya_veg, TRUE, in_header = FALSE))
head(count_taxa(family ~ ReleveID, Kenya_veg, TRUE))

}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
