% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_precision.R
\name{summary.verify_precision}
\alias{summary.verify_precision}
\title{Summary method for verify_precision objects}
\usage{
\method{summary}{verify_precision}(object, ...)
}
\arguments{
\item{object}{An object of class \code{verify_precision}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{summary.verify_precision} containing:
\describe{
\item{call}{The original function call.}
\item{input}{Input information.}
\item{observed}{Observed precision statistics.}
\item{claimed}{Claimed precision statistics.}
\item{test}{Hypothesis test results.}
\item{verification}{Verification outcome.}
\item{ci}{Confidence intervals.}
\item{settings}{Analysis settings.}
}
}
\description{
Provides a detailed summary of precision verification results, including
confidence intervals, test details, and interpretation guidance.
}
\examples{
set.seed(42)
measurements <- rnorm(25, mean = 100, sd = 3.5)
result <- verify_precision(measurements, claimed_cv = 4, mean_value = 100)
summary(result)

}
\seealso{
\code{\link[=print.verify_precision]{print.verify_precision()}} for concise output
}
