% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{troponin_cardiac}
\alias{troponin_cardiac}
\title{Cardiac Troponin Method Comparison Dataset}
\format{
A data frame with 50 observations and 3 variables:
\describe{
\item{sample_id}{Character. Unique sample identifier.}
\item{platform_a}{Numeric. Troponin I concentration (ng/L) measured by
platform A.}
\item{platform_b}{Numeric. Troponin I concentration (ng/L) measured by
platform B.}
}
}
\source{
Synthetic data generated to mimic realistic clinical patterns. See
\code{data-raw/make_datasets.R} for the generation script.
}
\usage{
troponin_cardiac
}
\description{
Synthetic dataset comparing high-sensitivity cardiac troponin I (hs-cTnI)
measurements from two different immunoassay platforms. This dataset
illustrates challenges in comparing troponin assays, which lack
standardization across manufacturers.
}
\details{
This synthetic dataset was designed to illustrate common patterns in
cardiac troponin method comparisons:

\itemize{
\item \strong{Concentration range}: 2-5000 ng/L, from near the limit of
detection to acute myocardial infarction levels
\item \strong{Distribution}: Log-normal (most values low, few very high),
reflecting typical clinical populations
\item \strong{Bias pattern}: Systematic proportional difference between
platforms (~15\%), reflecting lack of troponin assay standardization
\item \strong{Precision}: Higher CV at low concentrations near the detection
limit
}

Unlike many analytes, cardiac troponin assays are not standardized, meaning
results from different manufacturers are not directly comparable. This has
clinical implications for interpreting troponin values when patients are
tested at different institutions.
}
\examples{
# Bland-Altman analysis with percent differences
# (appropriate for proportional bias)
ba <- ba_analysis(platform_a ~ platform_b,
                  data = troponin_cardiac,
                  type = "percent")
summary(ba)
plot(ba)

}
\references{
Apple FS, et al. Cardiac Troponin Assays: Guide to Understanding Analytical
Characteristics and Their Impact on Clinical Care. Clin Chem.
2017;63(1):73-81.
}
\seealso{
\code{\link[=ba_analysis]{ba_analysis()}}, \link{glucose_methods}, \link{creatinine_serum}
}
\keyword{datasets}
