% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_natural_eff.R
\name{surv.natural.eff}
\alias{surv.natural.eff}
\title{Fit CIFs using hypothetical strategy (I) for competing risks data, based on efficient influence functions}
\usage{
surv.natural.eff(A, Time, cstatus, X = NULL)
}
\arguments{
\item{A}{Treatment indicator, 1 for treatment and 0 for control.}

\item{Time}{Time to event.}

\item{cstatus}{Indicator of event, 1 for the primary event, 2 for the intercurrent event, 0 for censoring.}

\item{X}{Baseline covariates.}
}
\value{
A list including
\describe{
\item{time1}{Time points in the treated group.}
\item{time0}{Time points in the control group.}
\item{cif1}{Estimated cumulative incidence function in the treated group.}
\item{cif0}{Estimated cumulative incidence function in the control group.}
\item{se1}{Standard error of the estimated cumulative incidence function in the treated group.}
\item{se0}{Standard error of the estimated cumulative incidence function in the control group.}
\item{time}{Time points in both groups.}
\item{ate}{Estimated treatment effect (difference in cumulative incidence functions).}
\item{se}{Standard error of the estimated treatment effect.}
\item{p.val}{P value of testing the treatment effect based on the efficient influence function of
the restricted mean survival time lost by the end of study.}
}
}
\description{
This function estimates the potential cumulative incidence function
based on efficient influence functions using hypothetical strategy (competing risks
data structure). Cox models are employed for survival models. The intercurrent event
is only permitted under treated if it would occur under control.
}
\details{
\describe{
The hypothetical strategy envisions a hypothetical clinical trial condition where the occurrence
of intercurrent events is restricted in certain ways. By doing so, the distribution of potential
outcomes under the hypothetical scenario can capture the impact of intercurrent events explicitly
through a pre-specified criterion. We use \eqn{T'(w)}, \eqn{w = 1, 0} to denote the time to the
primary outcome event in the hypothetical scenario. The time-dependent treatment effect specific
to this hypothetical scenario is written as
\eqn{\tau(t) = P(T'(1) < t) - P(T'(0) < t),}
representing the difference in probabilities of experiencing primary outcome events during \eqn{(0,t)}
in the pre-specified hypothetical scenario under active treatment and placebo. \cr
The key question is how to envision \eqn{T'(w)}. We manipulate the hazard specific to intercurrent
event \eqn{\lambda_2(t; w)} while assuming the hazard specific to the primary outcome event
\eqn{\lambda_1(t; w)} remains unchanged. Specifically, we envision that the intercurrent events that
occurred when individuals were assigned to test drugs were only permitted if these intercurrent events
would have also occurred if these individuals had been assigned to the placebo. In this hypothetical
scenario, when assigned to placebo, individuals would be equally likely to experience intercurrent
events as they are assigned to placebo in the real-world trial in terms of the hazards; when assigned
to test drug, the hazard of intercurrent events would be identical to that if assigned to placebo in
the real-world trial. That is, \eqn{\lambda_2'(t;0) = \lambda_2'(t;1) = \lambda_2(t;0)}. The treatment
effect corresponds to the natural direct effect with the hazard of intercurrent events set at
the level under control.
}
}
\seealso{
\code{\link[tteICE]{surv.natural}}, \code{\link[tteICE]{surv.tteICE}}
}
