% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptive_sampling.R
\name{weighted_kde}
\alias{weighted_kde}
\title{Weighted Kernel Density Estimation}
\usage{
weighted_kde(x, weights, n = 512, from = min(x), to = max(x))
}
\arguments{
\item{x}{A numeric vector of samples.}

\item{weights}{A numeric vector of weights corresponding to each sample in x.}

\item{n}{The integer number of points at which to evaluate the density.}

\item{from, to}{The range over which to evaluate the density.}
}
\value{
A list containing the evaluation points (\code{x}) and the estimated density values (\code{y}).
}
\description{
Performs weighted kernel density estimation for univariate data. This is useful for
analyzing parameter distributions where each sample has an associated importance
weight (e.g., a likelihood).
}
