% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_.R
\name{sp_upload}
\alias{sp_upload}
\alias{sp_download}
\title{Sharepoint upload/download}
\usage{
sp_upload(src, dest = basename(src), site = NULL, drive = NULL)

sp_download(
  src,
  dest = basename(src),
  site = NULL,
  drive = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{src}{Location of source file. Either a local path (for \code{sp_upload}), or a Sharepoint path (for \code{sp_download})}

\item{dest}{Location of destination file. If not provided, uses the same file name as \code{src}}

\item{site}{Site identifier. Can be the site name, id, URL, or an ms_site object. If no site identifier is provided, uses the stored default site if it exists.}

\item{drive}{Drive identifier. Can be the drive name, id, or an ms_drive object. If site is provided but drive is not, uses the first drive of the provided site. If neither is provided, uses the stored default drive if it exists.}

\item{overwrite}{Should the destination file be overwritten if it exists?}
}
\value{
Returns \code{dest} invisibly
}
\description{
\code{sp_upload()} and \code{sp_download()} wrap the \verb{$upload_file()} and \verb{$download_file()}
methods from the \link[Microsoft365R:ms_drive]{Microsoft365R::ms_drive} object. In addition, \code{sp_upload()} checks for the
existence of the destination folder and will prompt the user to create it if
it doesn't exist.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Set site defaults
sp_defaults("Data Analytics")

# List files
sp_list()

# Download a document locally
sp_download("Analysis Tools.docx", "AT.docx")

# Upload a document
sp_upload("AT.docx", "Analysis Tools.docx")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sp_read]{sp_read()}}, \code{\link[=sp_write]{sp_write()}}; \verb{$upload_file()} and \verb{$download_file()} from \link[Microsoft365R:ms_drive]{Microsoft365R::ms_drive}
}
