% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windows_pop_tajimas_d.R
\name{windows_pop_tajimas_d}
\alias{windows_pop_tajimas_d}
\title{Compute Tajima's D for a sliding window}
\usage{
windows_pop_tajimas_d(
  .x,
  type = c("matrix", "tidy", "list"),
  window_size,
  step_size,
  size_unit = c("snp", "bp"),
  min_loci = 1,
  complete = FALSE
)
}
\arguments{
\item{.x}{a (potentially grouped) \code{gen_tibble} object}

\item{type}{type of object to return, if using grouped method. One of
"matrix", "tidy", or "list". Default is "matrix".}

\item{window_size}{The size of the window to use for the estimates.}

\item{step_size}{The step size to use for the windows.}

\item{size_unit}{Either "snp" or "bp". If "snp", the window size and step
size are in number of SNPs. If "bp", the window size and step size are in
base pairs.}

\item{min_loci}{The minimum number of loci required to calculate a window
statistic. If the number of loci in a window is less than this, the window
statistic will be NA.}

\item{complete}{Should the function be evaluated on complete windows only? If
FALSE, the default, then partial computations will be allowed at the end of
the chromosome.}
}
\value{
if data is not grouped, a data frame with the following columns:
\itemize{
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{tajimas_d}: the Tajima's D for the population
if data are grouped, either:
a data frame as above with the following columns:
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{n_loci}: the number of loci in the window
\item \code{group}: the Tajima's D for the group for the given window  (there will be
as many of these columns as groups in the gen_tibble, and they will be
named by the grouping levels)
a tidy tibble with the following columns:
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{n_loci}: the number of loci in the window
\item \code{group}: the name of the group
\item \code{stat}: the Tajima's D for the given group at the given window
or a list of data frames, one per group, with the following columns:
\item \code{chromosome}: the chromosome for the window
\item \code{start}: the starting locus of the window
\item \code{end}: the ending locus of the window
\item \code{stat}: the Tajima's D for the given window
\item \code{n_loci}: the number of loci in the window
}
}
\description{
This function computes Tajima's D for a sliding window across
each chromosome.
}
\examples{
example_gt <- load_example_gt("grouped_gen_tbl")

# Calculate Tajima's D across a window of 3 SNPs, with a step size of 2 SNPs
example_gt \%>\%
  windows_pop_tajimas_d(
    window_size = 3, step_size = 2,
    size_unit = "snp", min_loci = 2
  )

}
