% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_king.R
\name{pairwise_king}
\alias{pairwise_king}
\title{Compute the KING-robust Matrix for a a \code{gen_tibble} object}
\usage{
pairwise_king(
  x,
  as_matrix = FALSE,
  block_size = bigstatsr::block_size(nrow(x))
)
}
\arguments{
\item{x}{a \code{gen_tibble} object.}

\item{as_matrix}{boolean, determining whether the results should be a square
symmetrical matrix (TRUE), or a tidied tibble (FALSE, the default)}

\item{block_size}{maximum number of loci read at once. More loci should
improve speed, but will tax memory.}
}
\value{
a square symmetrical matrix of relationship coefficients between
individuals if \code{as_matrix} is TRUE, or a tidied tibble of coefficients if
\code{as_matrix} is FALSE.
}
\description{
This function computes the KING-robust estimator of kinship.
}
\details{
Note that monomorphic sites are currently considered. Remove monomorphic
sites before running pairwise_king if this is a concern.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# Compute the KING-robust matrix
pairwise_king(example_gt, as_matrix = TRUE)

# Or return a tidy tibble
pairwise_king(example_gt, as_matrix = FALSE)

# Adjust block_size
pairwise_king(example_gt, block_size = 2)

}
