% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-chk.R
\name{date-expectations}
\alias{date-expectations}
\alias{expect_date_yyyy}
\alias{expect_date_yyyymm}
\alias{expect_date_yyyymmdd}
\title{Expectations: dates}
\usage{
expect_date_yyyy(vars, flt = TRUE, data = get_testdata())

expect_date_yyyymm(vars, flt = TRUE, data = get_testdata())

expect_date_yyyymmdd(vars, flt = TRUE, data = get_testdata())
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
Test whether variables in a data frame conform to a given date format such as
YYYYMMDD.
}
\examples{

sales <- data.frame(
  sale_id = 1:5,
  date = c("20200101", "20200101", "20200102", "20200103", "20220101"),
  quarter = c(202006, 202009, 202012, 20203, 20200101),
  published = c(1999, 19991, 21, 0001, 20200101)
)

try(expect_date_yyyymmdd(date, data = sales)) # Full date of sale valid
try(expect_date_yyyymm(quarter, data = sales)) # Quarters given as YYYYMM
try(expect_date_yyyy(published, data = sales)) # Publication years valid

}
\seealso{
\link[=chk-dates]{Checks: date}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
