% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{call_concatenate}
\alias{call_concatenate}
\title{Concatenate expressions via a binary operator}
\usage{
call_concatenate(args, bin_op = "+")
}
\arguments{
\item{args}{arguments to concatenate with operator}

\item{bin_op}{binary operator to concatenate it with}
}
\value{
a \code{call}
}
\description{
e.g. combine with \code{+} for \code{ggplot} without introducing parentheses due to associativity
}
\examples{
library(ggplot2)

# What we want to achieve
call("+", quote(f), quote(g))
call("+", quote(f), call("+", quote(g), quote(h))) # parentheses not wanted
call("+", call("+", quote(f), quote(g)), quote(h)) # as expected without unnecessary parentheses
Reduce(function(existing, new) call("+", existing, new), list(quote(f), quote(g), quote(h)))

# how we do it
call_concatenate(list(quote(f), quote(g), quote(h)))
call_concatenate(list(quote(f)))
call_concatenate(list())
call_concatenate(
  list(quote(ggplot(mtcars)), quote(geom_point(aes(wt, mpg))))
)

eval(
  call_concatenate(
    list(quote(ggplot(mtcars)), quote(geom_point(aes(wt, mpg))))
  )
)

}
