% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_isoreg.R
\name{learner_isoreg}
\alias{learner_isoreg}
\title{Construct a learner}
\usage{
learner_isoreg(formula, info = "targeted::isoregw", learner.args = NULL, ...)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link{isoregw}.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for isotonic regression with
\link{isoregw}.
}
\examples{
x <- runif(5e3, -5, 5)
pr <- lava::expit(-1 + x)
y <- rbinom(length(pr), 1, pr)
d <- data.frame(y, x)

lr <- learner_isoreg(y ~ x)
lr$estimate(d)
pr_iso <- lr$predict(d)

if (interactive()) {
  plot(pr ~ x, cex=0.3)
  lines(sort(x), pr_iso[order(x)], col="red", type="s")
}
}
