% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim}
\alias{sim}
\title{Simulate response of dynamic system}
\usage{
sim(model, input, addNoise = F, innov = NULL, seed = NULL)
}
\arguments{
\item{model}{the linear system to simulate}

\item{input}{a vector/matrix containing the input}

\item{addNoise}{logical variable indicating whether to add noise to the 
response model. (Default: \code{FALSE})}

\item{innov}{an optional times series of innovations. If not supplied (specified
as \code{NULL}), gaussian white noise is generated, with the variance specified in 
the model (Property: \code{noiseVar})}

\item{seed}{integer indicating the seed value of the random number generator.
Useful for reproducibility purposes.}
}
\value{
a vector containing the simulated output
}
\description{
Simulate the response of a system to a given input
}
\details{
The routine is currently built only for SISO systems. Future versions will
include support for MIMO systems.
}
\examples{
# ARX Model
u <- idinput(300,"rgs")
model <- idpoly(A=c(1,-1.5,0.7),B=c(0.8,-0.25),ioDelay=1,
noiseVar=0.1)
y <- sim(model,u,addNoise=TRUE)

}

