% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{write_survival_rates}
\alias{write_survival_rates}
\title{Write survival rates for one or multiple survival
analysis results in a CSV file.}
\usage{
write_survival_rates(
  ...,
  file,
  time_points,
  label = NULL,
  writer = write.csv,
  writer_args = list(),
  percentage_decimal_places = 1,
  time_precision = 0,
  timespan_unit = c("days", "months", "years")
)
}
\arguments{
\item{...}{Results generated by \code{\link{analyse_survival}},
or lists of such objects}

\item{file}{A connection, or a character string naming the file to print to.
(see \code{\link{cat}})}

\item{time_points}{Time points to compute survival rate at}

\item{label}{A label describing the result,
or a vector of the same size as results in ... (will then be mapped 1:1).
Recommended to distinguish result lines from multiple results in ...}

\item{writer}{A writer function such as write.csv}

\item{writer_args}{Parameters to pass to the writer function}

\item{percentage_decimal_places, time_precision}{Precision with which to print floating point values in their label form}

\item{timespan_unit}{Unit for time spans: "days", "months" or "years"}
}
\value{
None (invisible NULL).
}
\description{
As write_survival takes potentially multiple objects, it cannot
return its input in a cleanly defined way.
You can still elegantly combine \code{write_survival} in a pipe followed by
\code{\link{kaplan_meier_plot}} or \code{\link{kaplan_meier_grid}}
for a single input object if you apply the
tee pipe operator \code{\%T>\%} in front of \code{write_survival}.
}
