% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_output.R
\name{create_output}
\alias{create_output}
\title{Create Output for Sum Up}
\usage{
create_output(sentence_complete_output, sentences_lda, settings)
}
\arguments{
\item{sentence_complete_output}{A data frame containing sentence-level topic polarity scores.}

\item{sentences_lda}{An LDA model object containing topic-term distributions.}

\item{settings}{A list of settings containing parameters such as the number of topics,
threshold values, scoring scale, and output format.}
}
\value{
A structured list containing topic-wise feedback, strength, and quality assessments.
If \code{settings$output_json} is \code{TRUE}, returns a JSON string.
}
\description{
Processes sentence-level Sum Up's output, assigns sentences to topics,
calculates topic strengths, and organizes data into structured feedback categories.
}
\details{
This function processes Sum Up's output to assign sentences to topics based on
a probability threshold. It calculates the topic strength based on sentence polarity and recency,
categorizes topics by feedback quantity and quality, and includes unassigned feedback in a separate category.
}
