% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_group_tbl.R
\name{select_group_tbl}
\alias{select_group_tbl}
\title{Summarize multiple response variables by group}
\usage{
select_group_tbl(
  data,
  var_stem,
  group,
  escape_stem = FALSE,
  ignore_stem_case = FALSE,
  group_type = "variable",
  group_name = NULL,
  escape_group = FALSE,
  ignore_group_case = FALSE,
  remove_group_non_alnum = TRUE,
  na_removal = "listwise",
  pivot = "longer",
  only = NULL,
  var_labels = NULL,
  ignore = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{var_stem}{A character string of a variable stem or the full name of a
variable in \code{data}.}

\item{group}{A character string of a variable in \code{data} or a pattern to use to
search for variables in \code{data}.}

\item{escape_stem}{A logical value indicating whether to escape \code{var_stem}.
Default is \code{FALSE}.}

\item{ignore_stem_case}{A logical value indicating whether the search for columns
matching the supplied \code{var_stem} is case-insensitive. Default is \code{FALSE}.}

\item{group_type}{A character string that defines the type of grouping variable.
Should be one of \code{pattern} or \code{variable}. Default is \code{variable}, in which case the
variable matching the \code{group} string will be searched for within \code{data}.}

\item{group_name}{A character string piped to the final table to replace the name
of \code{group}.}

\item{escape_group}{A logical value indicating whether to escape string supplied
to \code{group}.}

\item{ignore_group_case}{A logical value indicating whether \code{group} is case-
insensitive. Default is \code{FALSE}.}

\item{remove_group_non_alnum}{A logical value indicating whether to remove all
non-alphanumeric characters (anything that is not a letter or number) from \code{group}.
Default is \code{TRUE}.}

\item{na_removal}{A character string specifying how to remove missing values.
Should be one of \code{pairwise} or \code{listwise}. Default is \code{listwise}.}

\item{pivot}{A character string specifying the format of the returned summary table.
The default is \code{longer}, which returns the data in long format. To return the data in
wide format, use \code{wider}.}

\item{only}{A character string or vector of character strings of the kinds of summary
data to return. Default is \code{NULL}, which returns counts (count) and percentages
(percent).}

\item{var_labels}{An optional named character vector or list where each element
maps labels to variable names. If any element is unnamed or if any labels do not
match variables in returned from \code{data}, all labels will be ignored and the table
will be printed without them.}

\item{ignore}{An optional named vector or list specifying values to exclude from
the dataset and analysis. By default, \code{NULL} includes all available values. To omit
values from variables returned by \code{var_stem}, use the provided stem as the name. To
exclude values from both \code{var_stem} variables and a grouping variable in \code{data},
supply a list.}
}
\value{
A tibble displaying frequency counts and/or percentages for each value of a
set of variables sharing the same variable stem. The results are grouped by either a
grouping variable in the data or by a pattern matched with variable names. When the
output is in the wider format, columns beginning with \code{count_value} and \code{percent_value}
prefixes report the count and percentage, respectively, for each distinct response
value of the variable within each group.
}
\description{
\code{select_group_tbl()} presents frequency counts and percentages
(count, percent) for binary (e.g., Unselected/Selected) and ordinal (e.g.,
strongly disagree to strongly agree) variables with the same variable stem
by some grouping variable. A variable stem is a common prefix found in related
variable names, often corresponding to similar survey items, that represents a
shared concept before unique identifiers (like timep oints) are added. For
example, in the \code{stem_social_psych} dataset, the two variables
\code{belong_belongStem_w1} and \code{belong_belongStem_w2} share the variable stem
\code{belong_belongStem} (e.g., "I feel like an outsider in STEM"), with suffixes
(_w1, _w2) indicating different measurement waves. By default, missing data are
excluded from the calculations in a listwise fashion.
}
\examples{
select_group_tbl(data = stem_social_psych,
                 var_stem = "belong_belong",
                 group = "\\\\d",
                 group_type = "pattern",
                 group_name = "wave",
                 na_removal = "pairwise",
                 pivot = "wider",
                 only = "count")

tas_recoded <-
  tas |>
  dplyr::mutate(sex = dplyr::case_when(
    sex == 1 ~ "female",
    sex == 2 ~ "male",
    TRUE ~ NA)) |>
  dplyr::mutate(dplyr::across(
    .cols = dplyr::starts_with("involved_"),
    .fns = ~ dplyr::case_when(
      .x == 1 ~ "selected",
      .x == 0 ~ "unselected",
      TRUE ~ NA)
  ))

select_group_tbl(data = tas_recoded,
                 var_stem = "involved_",
                 group = "sex",
                 group_type = "variable",
                 na_removal = "pairwise",
                 pivot = "wider")

depressive_recoded <-
  depressive |>
  dplyr::mutate(sex = dplyr::case_when(
    sex == 1 ~ "male",
    sex == 2 ~ "female",
    TRUE ~ NA)) |>
  dplyr::mutate(dplyr::across(
    .cols = dplyr::starts_with("dep_"),
    .fns = ~ dplyr::case_when(
      .x == 1 ~ "often",
      .x == 2 ~ "sometimes",
      .x == 3 ~ "hardly",
      TRUE ~ NA
    )
  ))

select_group_tbl(data = depressive_recoded,
                 var_stem = "dep",
                 group = "sex",
                 group_type = "variable",
                 na_removal = "listwise",
                 pivot = "wider",
                 only = "percent",
                 var_labels =
                   c("dep_1" = "how often child feels sad and blue",
                     "dep_2" = "how often child feels nervous, tense, or on edge",
                     "dep_3" = "how often child feels happy",
                     "dep_4" = "how often child feels bored",
                     "dep_5" = "how often child feels lonely",
                     "dep_6" = "how often child feels tired or worn out",
                     "dep_7" = "how often child feels excited about something",
                     "dep_8" = "how often child feels too busy to get everything"))

}
\author{
Ama Nyame-Mensah
}
