% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{sp_get_table_file}
\alias{sp_get_table_file}
\title{Get path to a CSV file containing a table.}
\usage{
sp_get_table_file(table_id, dataset_path, reunzip = FALSE)
}
\arguments{
\item{table_id}{Table ID; see \code{id} column in \code{sp_tables} for a list of available codelists.}

\item{dataset_path}{Path to downloaded dataset, as output by \code{sp_get_dataset()}}

\item{reunzip}{Whether to overwrite existing CSV files by unzipping the archive downlaoded by \code{sp_get_dataset()}. Defaults to FALSE.}
}
\value{
Character vector of length one - a path.
}
\description{
This is normally called inside \code{sp_get_table()} but can be used separately if
finer-grained control of intermediate outputs is needed, e.g. in a \code{{targets}} workflow.
}
\examples{
\dontrun{
ds <- sp_get_dataset("rozv", 2018, 12)
sp_get_table_file("balance-sheet", ds)
}
}
\seealso{
Other Detailed workflow: 
\code{\link{sp_get_codelist_file}()},
\code{\link{sp_get_codelist_url}()},
\code{\link{sp_get_dataset_url}()},
\code{\link{sp_load_codelist}()},
\code{\link{sp_load_table}()}
}
\concept{Detailed workflow}
