% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at-boundary.R
\name{ssd_at_boundary}
\alias{ssd_at_boundary}
\alias{ssd_at_boundary.tmbfit}
\alias{ssd_at_boundary.fitdists}
\title{Is At Boundary}
\usage{
ssd_at_boundary(x, ...)

\method{ssd_at_boundary}{tmbfit}(x, ...)

\method{ssd_at_boundary}{fitdists}(x, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}
}
\value{
A flag for each distribution indicating if one or more parameters at boundary.

A flag indicating if one or more parameters at boundary.

A logical vector for each distribution indicating if one or more parameters at boundary.
}
\description{
Generic function to test if one or more parameters is at boundary.
}
\section{Methods (by class)}{
\itemize{
\item \code{ssd_at_boundary(tmbfit)}: Is At Boundary for tmbfit Object

\item \code{ssd_at_boundary(fitdists)}: Is At Boundary for fitdists Object

}}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron,
  dists = c("lnorm", "lnorm_lnorm", "burrIII3")
)
ssd_at_boundary(fits$lnorm)
ssd_at_boundary(fits$lnorm_lnorm)
ssd_at_boundary(fits$burrIII3)

fits <- ssd_fit_dists(ssddata::ccme_boron,
  dists = c("lnorm", "lnorm_lnorm", "burrIII3")
)
ssd_at_boundary(fits)

}
