% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_proc.R
\name{auto_phase_bl}
\alias{auto_phase_bl}
\title{Perform zeroth-order phase correction based on expected baseline regions.}
\usage{
auto_phase_bl(
  mrs_data,
  ppm_start = c(0.5, 4),
  ppm_end = c(0, 4.2),
  xlim = c(1.8, 4),
  mean_dyns = FALSE,
  ret_phase = FALSE
)
}
\arguments{
\item{mrs_data}{an object of class \code{mrs_data}.}

\item{ppm_start}{a vector of ppm values designating baseline regions.}

\item{ppm_end}{a vectors of ppm values designating baseline regions.}

\item{xlim}{region containing signal of interest, eg strong metabolite
resonances.}

\item{mean_dyns}{phase the mean spectrum and apply the same value to each
dynamic.}

\item{ret_phase}{return phase values (logical).}
}
\value{
MRS data object with corrected phase.
}
\description{
Default arguments are appropriate for water suppressed 1H MRS of the brain.
The following options are suitable for a water signal at 4.65 ppm:
ppm_start = c(5.2, 4.0), ppm_end = c(5.3, 4.1), xlim = c(5.2, 4.1)
}
