% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HFWM_est.R
\name{HFWM_est}
\alias{HFWM_est}
\title{Estimation Function for Hierarchical Finlay-Wilkinson Model}
\usage{
HFWM_est(Y, VAR, ENV, kin_info = FALSE, A = NULL, env_info = FALSE,
  Z = NULL, inits = NULL, hyper_para = NULL, M_iter = 5000,
  burn_in = 3000, thin = 5, save_chain = FALSE, seed = NULL)
}
\arguments{
\item{Y}{A length-N numerical response vector}

\item{VAR}{A length-N factor/character vector indicating the genotype information of Y}

\item{ENV}{A length-N factor/character vector indicating the field information of Y}

\item{kin_info}{A logical parameter controling if to use kinship matrix}

\item{A}{kinship matrix, give value only if kin_info = TRUE}

\item{env_info}{A logical parameter controling whether to use environmental covariates}

\item{Z}{environmental covariates matrix with rownames = field names, give value only if env_info = TRUE}

\item{inits}{initial values, default is given}

\item{hyper_para}{hyper-parameter values, default is given}

\item{M_iter}{Total iteration number}

\item{burn_in}{Burn in number}

\item{thin}{Thinning value}

\item{save_chain}{A logical parameter controling whether to save MCMC chain: 'Chains.rds' in current working directory}

\item{seed}{Random seed value}
}
\value{
Mean estimates and RMSE value
}
\description{
This function ignores spatial effects.
}
\examples{
library(spFW)

# load data
data(spFW_example_data)
Y <- spFW_example_data$yield
VAR <- spFW_example_data$geno
ENV <- spFW_example_data$loc
COOR <- spFW_example_data[,c(4,5)]

# run model
fit0 <- HFWM_est(Y, VAR, ENV, M_iter = 1000, burn_in = 500, thin = 5)

# plot estimated Y
plot(Y, fit0$yhat)

}
