\name{slopeSuit}
\alias{slopeSuit}
\title{
A function for assessing slope suitability requirements for certain crops and trees
}
\description{
This function determines the suitability classes for slope requirements of selected agricultural crops and forest trees
}
\usage{
slopeSuit(value, crop)
}
\arguments{
  \item{value}{
Input land slope in degrees.
}
  \item{crop}{
The crop of interest for which slope suitability class is sought.
}
}
\details{
The input value can be map or just a numerical entry of slope in degrees
}
\value{
The output is slope suitability class for the crop. The output is an integer value for suitability class: 1- highly suitable; 2 - moderately suitable; 3 - marginally suitable; 4 - currently not suitable; 5 - not suitable
}
\references{
Sys, C., Van Ranst, E., Debaveye, J. and Beerneaert, F.1993. Land evaluation: Part III: Crop requirements.
Development Cooperation, Belgium.

Naidu, L.G.K., Ramamurthy, V., Challa O., Hegde, R. and Krishnan, P. 2006. Manual, Soil-site Suitability Criteria for Major Crops, National Bureau of Soil Survey and Land Use Planning, ICAR, Nagpur, India

FAO Crop Suitability Requirements: http://ecocrop.fao.org/ecocrop/srv/en/home
}
\author{
Christian Thine Omuto
}
\note{
The input slope value must be in degrees
}
\seealso{
LGPSuit, tempSuit, suitability
}
\examples{
slopeSuit(23.4,"carrot")
library(sp)
slopeSuit(23.4,"carrot")
slope=suitabinput["slope"]
slope$tea=slopeSuit(slope$slope,"tea")
slope$carrot=slopeSuit(slope$slope,"carrot")
summary(slope$carrot)
spplot(slope["carrot"])
}
