% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slcaControl.R
\name{slcaControl}
\alias{slcaControl}
\title{Control Parameters for \code{slca} Estimation}
\usage{
slcaControl(
  em.iterlim = 5000,
  em.tol = 1e-08,
  nlm.iterlim = 1000,
  nlm.tol = 1e-10,
  init.param = NULL,
  nrep = 1,
  test.iter = 500,
  na.rm = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{em.iterlim}{an integer specifying the maximum number of iterations allowed for the EM algorithm. The default is \code{5000}.}

\item{em.tol}{a numeric value setting the tolerance for convergence of the EM algorithm. The default is \code{1e-8}.}

\item{nlm.iterlim}{an integer specifying the maximum number of iterations allowed when using the \code{nlm} function for estimation. The default is \code{1000}.}

\item{nlm.tol}{a numeric value setting the tolerance for convergence of the \code{nlm} function. The default is \code{1e-10}.}

\item{init.param}{a numeric vector specifying the initial parameter values for estimation.}

\item{nrep}{an integer specifying the number of estimation trials. The default is \code{1}.}

\item{test.iter}{an integer specifying the maximum number of iterations allowed for parameter testing. The default is \code{500}.}

\item{na.rm}{a logical value indicating whether to remove observations containing missing values (\code{NA}). The default is \code{FALSE}.}

\item{verbose}{a logical value indicating whether to display progress updates during the estimation process. The default is \code{FALSE}.

A \code{list} containing control parameters for \code{slca} estimation, including the specified iteration limits, tolerances, and additional options.}
}
\description{
Specifies control parameters for estimating \code{slca} model.
}
\seealso{
\link{slca}
}
