% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_impute_missing_entries}
\alias{vaeac_impute_missing_entries}
\title{Impute Missing Values Using \code{vaeac}}
\usage{
vaeac_impute_missing_entries(
  x_explain_with_NaNs,
  n_MC_samples,
  vaeac_model,
  checkpoint,
  sampler,
  batch_size,
  verbose = NULL,
  seed = NULL,
  n_explain = NULL,
  index_features = NULL
)
}
\arguments{
\item{x_explain_with_NaNs}{A 2D matrix, where the missing entries to impute are represented by \code{NaN}.}

\item{n_MC_samples}{Integer. The number of imputed versions we create for each row in \code{x_explain_with_NaNs}.}

\item{vaeac_model}{An initialized \code{vaeac} model that we are going to use to generate the MC samples.}

\item{checkpoint}{List containing the parameters of the \code{vaeac} model.}

\item{sampler}{A sampler object used to sample the MC samples.}

\item{batch_size}{Positive integer (default is \code{64}). The number of samples to include in each batch
during the training of the vaeac model. Used in \code{\link[torch:dataloader]{torch::dataloader()}}.}

\item{verbose}{String vector or NULL.
Controls verbosity (printout detail level) via one or more of \code{"basic"}, \code{"progress"},
\code{"convergence"}, \code{"shapley"} and \code{"vS_details"}.
\code{"basic"} (default) displays basic information about the computation and messages about parameters/checks.
\code{"progress"} displays where in the calculation process the function currently is.
\code{"convergence"} displays how close the Shapley value estimates are to convergence
(only when \code{iterative = TRUE}).
\code{"shapley"} displays intermediate Shapley value estimates and standard deviations (only when \code{iterative = TRUE}),
and the final estimates.
\code{"vS_details"} displays information about the v(S) estimates,
most relevant for \code{approach \%in\% c("regression_separate", "regression_surrogate", "vaeac")}.
\code{NULL} means no printout.
Any combination can be used, e.g., \code{verbose = c("basic", "vS_details")}.}

\item{seed}{Positive integer (default is \code{1}). Seed for reproducibility. Specifies the seed before any randomness
based code is being run.}

\item{n_explain}{Positive integer. The number of explicands.}

\item{index_features}{Optional integer vector. Used internally in shapr package to index the coalitions.}
}
\value{
A data.table where the missing values (\code{NaN}) in \code{x_explain_with_NaNs} have been imputed \code{n_MC_samples}
times.
The data table will contain extra id columns if \code{index_features} and \code{n_explain} are provided.
}
\description{
Impute Missing Values Using \code{vaeac}
}
\details{
Function that imputes the missing values in 2D matrix where each row constitute an individual.
The values are sampled from the conditional distribution estimated by a vaeac model.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
