% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R, R/tidyverse.R
\name{tidyverse}
\alias{tidyverse}
\alias{inner_join.sftime}
\alias{left_join.sftime}
\alias{right_join.sftime}
\alias{full_join.sftime}
\alias{semi_join.sftime}
\alias{anti_join.sftime}
\alias{filter.sftime}
\alias{arrange.sftime}
\alias{group_by.sftime}
\alias{ungroup.sftime}
\alias{rowwise.sftime}
\alias{mutate.sftime}
\alias{transmute.sftime}
\alias{select.sftime}
\alias{rename.sftime}
\alias{slice.sftime}
\alias{summarise.sftime}
\alias{summarize.sftime}
\alias{distinct.sftime}
\alias{gather.sftime}
\alias{pivot_longer.sftime}
\alias{spread.sftime}
\alias{sample_n.sftime}
\alias{sample_frac.sftime}
\alias{nest.sftime}
\alias{unnest.sftime}
\alias{separate.sftime}
\alias{unite.sftime}
\alias{separate_rows.sftime}
\alias{drop_na.sftime}
\title{'tidyverse' methods for \code{sftime} objects}
\usage{
inner_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

anti_join.sftime(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

filter.sftime(.data, ..., .dots)

arrange.sftime(.data, ..., .dots)

group_by.sftime(.data, ..., add = FALSE)

ungroup.sftime(.data, ...)

rowwise.sftime(.data, ...)

mutate.sftime(.data, ..., .dots)

transmute.sftime(.data, ..., .dots)

select.sftime(.data, ...)

rename.sftime(.data, ...)

slice.sftime(.data, ..., .dots)

summarise.sftime(.data, ..., .dots, do_union = TRUE, is_coverage = FALSE)

summarize.sftime(.data, ..., .dots, do_union = TRUE, is_coverage = FALSE)

distinct.sftime(.data, ..., .keep_all = FALSE)

gather.sftime(
  data,
  key,
  value,
  ...,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)

pivot_longer.sftime(
  data,
  cols,
  names_to = "name",
  names_prefix = NULL,
  names_sep = NULL,
  names_pattern = NULL,
  names_ptypes = NULL,
  names_transform = NULL,
  names_repair = "check_unique",
  values_to = "value",
  values_drop_na = FALSE,
  values_ptypes = NULL,
  values_transform = NULL,
  ...
)

spread.sftime(
  data,
  key,
  value,
  fill = NA,
  convert = FALSE,
  drop = TRUE,
  sep = NULL
)

sample_n.sftime(
  tbl,
  size,
  replace = FALSE,
  weight = NULL,
  .env = parent.frame()
)

sample_frac.sftime(
  tbl,
  size = 1,
  replace = FALSE,
  weight = NULL,
  .env = parent.frame()
)

nest.sftime(.data, ...)

unnest.sftime(data, ..., .preserve = NULL)

separate.sftime(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)

unite.sftime(data, col, ..., sep = "_", remove = TRUE)

separate_rows.sftime(data, ..., sep = "[^[:alnum:]]+", convert = FALSE)

drop_na.sftime(data, ...)
}
\arguments{
\item{x}{An object of class \code{sftime}.}

\item{y}{See \code{dplyr::`mutate-joins`}.}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{other arguments}

\item{.data}{An object of class \code{stime}.}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{add}{see corresponding function in dplyr}

\item{do_union}{logical; in case \code{summary} does not create a geometry column, should geometries be created by unioning using \link[sf]{st_union}, or simply by combining using \link[sf]{st_combine}? Using \link[sf]{st_union} resolves internal boundaries, but in case of unioning points, this will likely change the order of the points; see Details.}

\item{is_coverage}{logical; if \code{do_union} is \code{TRUE}, use an optimized algorithm for features that form a polygonal coverage (have no overlaps)}

\item{.keep_all}{see corresponding function in dplyr}

\item{data}{see original function docs}

\item{key}{see original function docs}

\item{value}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see \link[tidyr]{separate_rows}}

\item{factor_key}{see original function docs}

\item{cols}{see original function docs}

\item{names_to}{see original function docs}

\item{names_prefix}{see original function docs}

\item{names_sep}{see original function docs}

\item{names_pattern}{see original function docs}

\item{names_ptypes}{see original function docs}

\item{names_transform}{see original function docs}

\item{names_repair}{see original function docs}

\item{values_to}{see original function docs}

\item{values_drop_na}{see original function docs}

\item{values_ptypes}{see original function docs}

\item{values_transform}{see original function docs}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see \link[tidyr]{separate_rows}}

\item{tbl}{see original function docs}

\item{size}{see original function docs}

\item{replace}{see original function docs}

\item{weight}{see original function docs}

\item{.env}{see original function docs}

\item{.preserve}{see \link[tidyr:nest]{unnest}}

\item{col}{see \link[tidyr]{separate}}

\item{into}{see \link[tidyr]{separate}}

\item{remove}{see \link[tidyr]{separate}}

\item{extra}{see \link[tidyr]{separate}}
}
\value{
\itemize{
  \item For \code{_join} methods: An object of class \code{sftime} 
  representing the joining result of \code{x} and \code{y}. See 
  \code{\link[dplyr]{mutate-joins}}.
  \item For \code{filter}: See \code{\link[dplyr]{filter}}.
  \item For \code{arrange}: See \code{\link[dplyr]{arrange}}. 
  \item For \code{group_by} and \code{ungroup}: A grouped \code{sftime} 
  object. See \code{\link[dplyr]{arrange}}. 
  \item For \code{rowwise}: An \code{sftime} object. See 
  \code{\link[dplyr]{rowwise}}. 
  \item For \code{mutate} and \code{transmute}: See 
  \code{\link[dplyr]{mutate}}.
  \item For \code{select}: See \code{\link[dplyr]{select}}. If the active 
  time column is not explicitly selected, a \code{sf} object is returned. 
  \item For \code{rename}: See \code{\link[dplyr]{rename}}.    
  \item For \code{slice}: See \code{\link[dplyr]{slice}}.
  \item For \code{summarize} and \code{summarise}: See 
  \code{\link[dplyr]{summarise}}.  
  \item For \code{distinct}: See \code{\link[dplyr]{distinct}}.
  \item For \code{gather}: See \code{\link[tidyr]{gather}}. 
}
}
\description{
'tidyverse' methods for \code{sftime} objects. Geometries are sticky, use 
\code{\link{as.data.frame}} to let \code{dplyr}'s own methods drop them. Use 
these methods without the \code{.sftime} suffix and after loading the 
'tidyverse' package with the generic (or after loading package 'tidyverse').
}
\examples{
g1 <- st_sfc(st_point(1:2), st_point(c(5, 8)), st_point(c(2, 9)))
x1 <- st_sftime(a = 1:3, geometry = g1, time = Sys.time())

g2 <- st_sfc(st_point(c(4, 6)), st_point(c(4, 6)), st_point(c(4, 6)))
x2 <- st_sftime(a = 2:4, geometry = g2, time = Sys.time())

library(dplyr)

## inner_join
inner_join(x1, as.data.frame(x2), by = "a") # note: the active time column is
# time.x and the active geometry column geometry.x

inner_join(x2, as.data.frame(x1), by = "a")

## left_join
left_join(x1, as.data.frame(x2), by = "a")

left_join(x2, as.data.frame(x1), by = "a")

## right_join
right_join(x1, as.data.frame(x2), by = "a")

right_join(x2, as.data.frame(x1), by = "a")

## full_join
full_join(x1, as.data.frame(x2), by = "a")

full_join(x2, as.data.frame(x1), by = "a")

## semi_join
semi_join(x1, as.data.frame(x2), by = "a")

semi_join(x2, as.data.frame(x1), by = "a")

## anti_join
anti_join(x1, as.data.frame(x2), by = "a")

anti_join(x2, as.data.frame(x1), by = "a")

## filter
filter(x1, a <= 2)

## arrange
arrange(x1, dplyr::desc(a))

## group_by
group_by(x1, time)

## ungroup
ungroup(group_by(x1, time))

## rowwise
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  rowwise() \%>\%
  mutate(a2 = mean(a, a1))

## mutate
x1 \%>\%
  mutate(a1 = 5:7)

## transmute
x1 \%>\%
  transmute(a1 = 5:7)

## select
x1 \%>\%
  select(-time) \%>\%
  select(geometry)

## rename
x1 \%>\%
  rename(a1 = a)

## slice
x1 \%>\%
  slice(1:2)

## summarise
x1 \%>\%
  summarise(time = mean(time))
  
x1 \%>\%
  summarize(time = mean(time))

## distinct
x1 \%>\%
  distinct(geometry)

## gather
library(tidyr)
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  gather(key = "variable", value = "value", a, a1)

## pivot_longer
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  pivot_longer(cols = c("a", "a1"), names_to = "variable", values_to = "value")

## spread
x1 \%>\%
  mutate(a1 = 5:7) \%>\%
  gather(key = "variable", value = "value", a, a1) \%>\%
  spread(key = "variable", value = "value")

## sample_n
set.seed(234)
x1 \%>\%
  sample_n(size = 10, replace = TRUE)

## sample_frac
x1 \%>\%
  sample_frac(size = 10, replace = TRUE) \%>\%
  sample_frac(size = 0.1, replace = FALSE)

## nest
x1 \%>\%
  nest(a1 = -time)

## unnest
x1 \%>\%
  mutate(a1 = list(1, c(1, 2), 5)) \%>\%
  unnest(a1)

## separate
x1 \%>\%
  mutate(x = c(NA, "a.b", "a.d")) \%>\%
  separate(x, c("A", "B"))

## unite
x1 \%>\%
  mutate(x = c(NA, "a.b", "a.d")) \%>\%
  separate(x, c("A", "B")) \%>\%
  unite(x, c("A", "B"))
  
## separate_rows
x1 \%>\%
  mutate(z = c("1", "2,3,4", "5,6")) \%>\%
  separate_rows(z, convert = TRUE)

## drop_na
x1 \%>\%
  mutate(z = c(1, 2, NA)) \%>\%
  drop_na(z)
  
x1 \%>\%
  mutate(z = c(1, NA, NA)) \%>\%
  drop_na(z)   

x1 \%>\%
  mutate(time = replace(time, 1, NA)) \%>\%
  drop_na(time)
}
