% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived_variables.R
\name{calcVelocity}
\alias{calcVelocity}
\title{Calculate velocity}
\usage{
calcVelocity(list)
}
\arguments{
\item{list}{A list of data frames, where each data frame has a column for dT,
dx, and dy.}
}
\value{
A list of data frames that each contain a column for velocity.
}
\description{
Calculate the average velocity between two location recordings
}
\details{
This function calculates the velocity of the organism on the servosphere
between two location recordings. The units for velocity will be distance per
second, where distance is the units of distance used by the software in
recording the movement of the organism. For example, if the software recorded
distance in centimeters, the units for velocity will be centimeters per
second.

If the data will be aggregated, it is recommended to aggregate the data before
running this function.
}
\examples{
 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))

servosphere <- calcVelocity(servosphere)
}
