% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParDiffForest.R
\name{getParDiffForest}
\alias{getParDiffForest}
\title{Return list with parameter differences of a forest}
\usage{
getParDiffForest(forest, measure = "wald", normalize = FALSE)
}
\arguments{
\item{forest}{a semforest object.}

\item{measure}{a character. "wald" (default) gives the squared parameter
differences divided by their pooled standard errors. test" gives the
contributions of the parameters to the test statistic. "raw" gives the
absolute values of the parameter differences.}

\item{normalize}{logical value; if TRUE parameter differences of each split
are divided by sum of all differences the corresponding split. Set to FALSE
by default.}
}
\value{
A list with data.frames containing parameter differences for each
tree of the forest. The rows of the data.frames correspond to the non-leaf
nodes of the respective trees. The first column contains the name of the
predictor variables and the remaining columns contain the parameter
differences. The rows of the data.frames are named by the node IDs as given
\code{getNodeById} and the columns are named as in \code{coef}.
}
\description{
Returns a list of tables with some measure of parameter
differences between post-split nodes.
}
\author{
Manuel Arnold
}
