% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_simplePLS.R
\name{simplePLS}
\alias{simplePLS}
\title{seminr simplePLS Function}
\usage{
simplePLS(obsData,smMatrix, mmMatrix,inner_weights = path_weighting,
          maxIt=300, stopCriterion=7,measurement_mode_scheme)
}
\arguments{
\item{obsData}{A \code{dataframe} containing the indicator measurement data.}

\item{smMatrix}{A source-to-target matrix representing the inner/structural model,
generated by \code{relationships}.}

\item{mmMatrix}{A source-to-target matrix representing the outer/measurement model,
generated by \code{constructs}.}

\item{inner_weights}{A parameter declaring which inner weighting scheme should be used
path_weighting is default, alternately path_factorial can be used.}

\item{maxIt}{The maximum number of iterations to run (default is 300).}

\item{stopCriterion}{The criterion to stop iterating (default is 7).}

\item{measurement_mode_scheme}{A named list of constructs and measurement scheme functions}
}
\value{
A list of the estimated parameters for the SimplePLS model including:
 \item{meanData}{A vector of the indicator means.}
 \item{sdData}{A vector of the indicator standard deviations}
 \item{mmMatrix}{A Matrix of the measurement model relations.}
 \item{smMatrix}{A Matrix of the structural model relations.}
 \item{constructs}{A vector of the construct names.}
 \item{mmVariables}{A vector of the indicator names.}
 \item{outer_loadings}{The matrix of estimated indicator loadings.}
 \item{outer_weights}{The matrix of estimated indicator weights.}
 \item{path_coef}{The matrix of estimated structural model relationships.}
 \item{iterations}{A numeric indicating the number of iterations required before the algorithm converged.}
 \item{weightDiff}{A numeric indicating the minimum weight difference between iterations of the algorithm.}
 \item{construct_scores}{A matrix of the estimated construct scores for the PLS model.}
 \item{rSquared}{A matrix of the estimated R Squared for each construct.}
 \item{inner_weights}{The inner weight estimation function.}
}
\description{
The \code{seminr} package provides a natural syntax for researchers to describe PLS
structural equation models. \code{seminr} is compatible with simplePLS.
\code{simplePLS} provides the verb for estimating a pls model.
}
\examples{
#seminr syntax for creating measurement model
mobi_mm <- constructs(
             reflective("Image",        multi_items("IMAG", 1:5)),
             reflective("Expectation",  multi_items("CUEX", 1:3)),
             reflective("Quality",      multi_items("PERQ", 1:7)),
             reflective("Value",        multi_items("PERV", 1:2)),
             reflective("Satisfaction", multi_items("CUSA", 1:3)),
             reflective("Complaints",   single_item("CUSCO")),
             reflective("Loyalty",      multi_items("CUSL", 1:3))
           )
#seminr syntax for creating structural model
mobi_sm <- relationships(
  paths(from = "Image",        to = c("Expectation", "Satisfaction", "Loyalty")),
  paths(from = "Expectation",  to = c("Quality", "Value", "Satisfaction")),
  paths(from = "Quality",      to = c("Value", "Satisfaction")),
  paths(from = "Value",        to = c("Satisfaction")),
  paths(from = "Satisfaction", to = c("Complaints", "Loyalty")),
  paths(from = "Complaints",   to = "Loyalty")
)

mobi_pls <- estimate_pls(data = mobi,
                           measurement_model = mobi_mm,
                           structural_model = mobi_sm)

}
\seealso{
\code{\link{relationships}} \code{\link{constructs}} \code{\link{paths}} \code{\link{interaction_term}}
         \code{\link{estimate_pls}} \code{\link{bootstrap_model}}
}
