## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
pkgload::load_all()

## ----setup--------------------------------------------------------------------
library(scrutiny)

## -----------------------------------------------------------------------------
grimmer(x = "7.3", sd = "2.51", n = 12)

## -----------------------------------------------------------------------------
flying_pigs1 <- tibble::tribble(
  ~x,   ~sd,    ~n,
"8.9",  "2.81",  25,
"2.6",  "2.05",  25,
"7.2",  "2.89",  25,
"3.6",  "3.11",  25,
"9.2",  "7.13",  25,
"10.4", "2.53",  25,
"7.3",  "3.14",  25
)

## ----error=TRUE---------------------------------------------------------------
grimmer_map(flying_pigs1)

## ----error=TRUE---------------------------------------------------------------
flying_pigs2 <- tibble::tribble(
   ~x,    ~sd,    ~n,
  "5.90", "2.19",  40,
  "5.71", "1.42",  40,
  "3.50", "1.81",  40,
  "3.82", "2.43",  40,
  "4.61", "1.92",  40,
  "5.24", "2.51",  40
)

flying_pigs2 %>% 
  grimmer_map()  # default is wrong here!

## ----error=TRUE---------------------------------------------------------------
flying_pigs2 %>% 
  grimmer_map(items = 3)

## ----error=TRUE---------------------------------------------------------------
flying_pigs3 <- tibble::tribble(
   ~x,     ~sd,    ~n,  ~items,
  "6.92",  "2.19",  30,  1,
  "3.48",  "1.42",  30,  1,
  "1.59",  "1.81",  30,  2,
  "2.61",  "2.43",  30,  2,
  "4.04",  "1.92",  30,  3,
  "4.50",  "2.51",  30,  3,
)

flying_pigs3 %>% 
  grimmer_map()

## -----------------------------------------------------------------------------
flying_pigs3 %>%
    dplyr::select(-items) %>% 
    grimmer_map()

## -----------------------------------------------------------------------------
flying_pigs1 %>% 
  grimmer_map() %>% 
  audit()

## ----fig.width=6, fig.height=5.5----------------------------------------------
flying_pigs4 <- tibble::tribble(
  ~x,      ~sd,    ~n,
  "7.19",  "1.19",  54,
  "4.56",  "2.56",  66,
  "0.42",  "1.29",  59,
  "1.31",  "3.50",  57,
  "3.48",  "3.65",  66,
  "4.27",  "2.86",  61,
  "6.21",  "2.15",  62,
  "3.11",  "3.17",  50,
  "5.39",  "2.37",  68,
  "5.66",  "1.11",  44,
)


flying_pigs4 %>% 
  grimmer_map() %>% 
  grim_plot()

## ----error=TRUE---------------------------------------------------------------
grim_plot(mtcars)

## -----------------------------------------------------------------------------
out_seq1 <- grimmer_map_seq(pigs5)
out_seq1

## -----------------------------------------------------------------------------
audit_seq(out_seq1)

## -----------------------------------------------------------------------------
out_seq2 <- grimmer_map_seq(pigs5, dispersion = 1:10)
audit_seq(out_seq2)

## ----fig.width=6, fig.height=5.5----------------------------------------------
grim_plot(out_seq1)

## ----fig.width=6, fig.height=5.5----------------------------------------------
out_seq1_only_x <- grimmer_map_seq(pigs5, var = "x")
out_seq1_only_n <- grimmer_map_seq(pigs5, var = "n")

grim_plot(out_seq1_only_x)
grim_plot(out_seq1_only_n)

## -----------------------------------------------------------------------------
flying_pigs5 <- tibble::tribble(
    ~x1,    ~x2,    ~sd1,   ~sd2,   ~n,
    "3.43", "5.28", "1.09", "2.12", 70,
    "2.97", "4.42", "0.43", "1.65", 65
)

out_total_n <- grimmer_map_total_n(flying_pigs5)
out_total_n

audit_total_n(out_total_n)

