% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{scan_eb_negbin_cpp}
\alias{scan_eb_negbin_cpp}
\title{Calculate the expectation-based negative binomial scan statistic.}
\usage{
scan_eb_negbin_cpp(
  counts,
  baselines,
  overdisp,
  zones,
  zone_lengths,
  store_everything,
  num_mcsim,
  score_hotspot
)
}
\arguments{
\item{counts}{Integer matrix (most recent timepoint in first row)}

\item{baselines}{Matrix (most recent timepoint in first row)}

\item{overdisp}{Matrix (most recent timepoint in first row)}

\item{zones}{Integer vector (all zones concatenated; locations indexed from
0 and up)}

\item{zone_lengths}{Integer vector}

\item{store_everything}{Boolean}

\item{num_mcsim}{Integer}

\item{score_hotspot}{Boolean}
}
\value{
A list with elements \code{observed} and \code{simulated}, each 
   being a data frame with columns:
   \describe{
     \item{zone}{The top-scoring zone (spatial component of MLC).}
     \item{duration}{The corresponding duration (time-length of MLC).}
     \item{score}{The value of the loglihood ratio statistic (the scan
                  statistic).}
     \item{relrisk}{The estimated relative risk.}
     \item{n_iter}{The number of iterations performed by the EM algorithm.}
   }
}
\description{
Calculate the expectation-based negative binomial scan statistic and Monte
Carlo replicates.
}
\keyword{internal}
