% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTS_Server.R
\name{CTS_init_state}
\alias{CTS_init_state}
\title{Initialize CTS Module State}
\usage{
CTS_init_state(FM_yaml_file, MOD_yaml_file, id, id_MB, session)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section}

\item{MOD_yaml_file}{Module configuration file with MC as main section}

\item{id}{ID string for the module}

\item{id_MB}{An ID string that corresponds with the ID used to call the MB modules}

\item{session}{Shiny session variable}
}
\value{
list containing an empty CTS state
}
\description{
Creates a list of the initialized module state
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = MB_test_mksession()
session = sess_res$session
input   = sess_res$input

state = CTS_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "ruminate",
                               "templates",
                               "CTS.yaml"),
   id              = "CTS",
   id_MB           = "MB",
   session         = session)

state
}
