% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtsplot.r
\name{rtsplot.fake.stock.data}
\alias{rtsplot.fake.stock.data}
\title{Generate fake stock data}
\usage{
rtsplot.fake.stock.data(
  n,
  y0 = 10,
  stdev = 0.1,
  ohlc = FALSE,
  method = c("normal", "adhoc"),
  period = c("day", "minute"),
  remove.non.trading = FALSE
)
}
\arguments{
\item{n}{number of points to generate}

\item{y0}{starting price, \strong{defaults to 10 }}

\item{stdev}{standard deviation, \strong{defaults to 0.1}}

\item{ohlc}{generate ohlc data, \strong{defaults to FALSE}}

\item{method}{method to generate fake stock data, \strong{defaults to 'normal'}
two methods are implemented: 
* 'normal' - generate fake stock data assuming returns 
are normally distributed with zero drift
* 'uniform' - generate fake stock data assuming returns 
are uniformly distributed with zero drift}

\item{period}{frequency to generate fake stock data, (possible values: "day", "minute"),  \strong{defaults to "day"}}

\item{remove.non.trading}{flag to remove non trading periods(i.e. weekends and non-trading hours).
Note, this flag likely will cause function return less than 'n' observation, \strong{defaults to FALSE}}
}
\value{
\code{\link{xts}} object with fake stock data
}
\description{
Generate fake stock data for use in rtsplot examples
}
\examples{
 rtsplot.fake.stock.data(10)

}
