% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configureApp.R
\name{configureApp}
\alias{configureApp}
\title{Configure an Application}
\usage{
configureApp(
  appName,
  appDir = getwd(),
  account = NULL,
  server = NULL,
  redeploy = TRUE,
  size = NULL,
  instances = NULL,
  logLevel = c("normal", "quiet", "verbose")
)
}
\arguments{
\item{appName}{Name of application to configure}

\item{appDir}{Directory containing application. Defaults to
current working directory.}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{redeploy}{Re-deploy application after its been configured.}

\item{size}{Configure application instance size}

\item{instances}{Configure number of application instances}

\item{logLevel}{One of \code{"quiet"}, \code{"normal"} or \code{"verbose"}; indicates how
much logging to the console is to be performed. At \code{"quiet"} reports no
information; at \code{"verbose"}, a full diagnostic log is captured.}
}
\description{
Configure an application running on a remote server.

Supported servers: ShinyApps servers
}
\note{
This function works only for ShinyApps servers.
}
\examples{
\dontrun{

# set instance size for an application
configureApp("myapp", size="xlarge")
}
}
\seealso{
\code{\link[=applications]{applications()}}, \code{\link[=deployApp]{deployApp()}}
}
