% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedding.R
\name{runTSNE}
\alias{runTSNE}
\title{Perform t-SNE dimensionality reduction}
\usage{
runTSNE(
  object,
  useRaw = NULL,
  useDims = NULL,
  nDims = 2,
  usePCA = FALSE,
  perplexity = 30,
  theta = 0.5,
  method = c("Rtsne", "fftRtsne"),
  dimredName = "TSNE",
  asDefault = NULL,
  fitsnePath = NULL,
  seed = 42,
  verbose = getOption("ligerVerbose", TRUE),
  k = nDims,
  use.raw = useRaw,
  dims.use = useDims,
  use.pca = usePCA,
  fitsne.path = fitsnePath,
  rand.seed = seed
)
}
\arguments{
\item{object}{\linkS4class{liger} object with factorization results.}

\item{useRaw}{Whether to use un-aligned cell factor loadings (\eqn{H}
matrices). Default \code{NULL} search for aligned factor loadings first
and un-aligned loadings then.}

\item{useDims}{Index of factors to use for computing the embedding. Default
\code{NULL} uses all factors.}

\item{nDims}{Number of dimensions to reduce to. Default \code{2}.}

\item{usePCA}{Whether to perform initial PCA step for Rtsne. Default
\code{FALSE}.}

\item{perplexity}{Numeric parameter to pass to Rtsne (expected number of
neighbors). Default \code{30}.}

\item{theta}{Speed/accuracy trade-off (increase for less accuracy), set to
\code{0.0} for exact TSNE. Default \code{0.5}.}

\item{method}{Choose from \code{"Rtsne"} or \code{"fftRtsne"}. See
Description. Default \code{"Rtsne"}.}

\item{dimredName}{Name of the variable in \code{cellMeta} slot to store the
result matrix. Default \code{"TSNE"}.}

\item{asDefault}{Logical, whether to set the resulting dimRed as default for
visualization. Default \code{NULL} will set it when no default is set.}

\item{fitsnePath}{Path to the cloned FIt-SNE directory (i.e.
\code{'/path/to/dir/FIt-SNE'}). Required only when first time using
\code{runTSNE} with \code{method = "fftRtsne"}. Default \code{NULL}.}

\item{seed}{Random seed for reproducibility. Default \code{42}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{use.raw, dims.use, k, use.pca, fitsne.path, rand.seed}{\bold{Deprecated}.
See Usage section for replacement.}
}
\value{
The \code{object} where a \code{"TSNE"} variable is updated in the
\code{cellMeta} slot with the whole 2D embedding matrix.
}
\description{
Runs t-SNE on the aligned cell factors (result from
\code{\link{alignFactors}}), or unaligned cell factors (result from
\code{\link{runIntegration}})) to generate a 2D embedding for visualization.
By default \code{\link[Rtsne]{Rtsne}} (Barnes-Hut implementation of t-SNE)
method is invoked, while alternative "fftRtsne" method (FFT-accelerated
Interpolation-based t-SNE, using Kluger Lab implementation) is also
supported. For very large datasets, it is recommended to use
\code{method = "fftRtsne"} due to its efficiency and scalability.

Extra external installation steps are required for using "fftRtsne" method.
Please consult
\href{https://welch-lab.github.io/liger/articles/installation.html}{detailed guide}.
}
\examples{
pbmc <- runTSNE(pbmcPlot)
}
\seealso{
\code{\link{runUMAP}}
}
