% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/honnorat.R
\name{rigid_harmonization}
\alias{rigid_harmonization}
\title{Harmonize Tangent Images Across Batches Using Rigid Correction}
\usage{
rigid_harmonization(super_sample)
}
\arguments{
\item{super_sample}{A \code{CSuperSample} object containing samples to harmonize.}
}
\value{
A new \code{CSuperSample} object with harmonized tangent images.
}
\description{
Applies a rigid harmonization procedure to tangent images
in a \code{CSuperSample} object.
First, batch means are subtracted from each sample's
tangent images (batch correction), then the overall mean is added back
(global correction). The harmonized tangent images are used
to reconstruct new \code{CSample} objects, which are collected
into a new \code{CSuperSample}.
}
\details{
This function performs harmonization in two steps:
\enumerate{
\item \strong{Batch Correction:} For each batch, the mean
of its tangent images is subtracted from each tangent image in the batch.
\item \strong{Global Correction:} The overall mean (across all batches)
of tangent images is added back to each tangent image.
}
The harmonized tangent images are then used to reconstruct samples
using the reference point and metric from the original \code{CSuperSample}.
}
