% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/python.R
\name{as_iterator}
\alias{as_iterator}
\alias{iterate}
\alias{iter_next}
\title{Traverse a Python iterator or generator}
\usage{
as_iterator(x)

iterate(it, f = base::identity, simplify = TRUE)

iter_next(it, completed = NULL)
}
\arguments{
\item{x}{Python iterator or iterable}

\item{it}{Python iterator or generator}

\item{f}{Function to apply to each item. By default applies the
\code{identity} function which just reflects back the value of the item.}

\item{simplify}{Should the result be simplified to a vector if possible?}

\item{completed}{Sentinel value to return from \code{iter_next()} if the iteration
completes (defaults to \code{NULL} but can be any R value you specify).}
}
\value{
For \code{iterate()}, A list or vector containing the results of calling
\code{f} on each item in \code{x} (invisibly); For \code{iter_next()}, the next
value in the iteration (or the sentinel \code{completed} value if the iteration
is complete).
}
\description{
Traverse a Python iterator or generator
}
\details{
Simplification is only attempted all elements are length 1 vectors
of type "character", "complex", "double", "integer", or "logical".
}
