% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_write.R
\name{write_to_copy_rmds}
\alias{write_to_copy_rmds}
\title{Write a local copy of RMD or Rmarkdown files}
\usage{
write_to_copy_rmds(
  dir_path_1L_chr,
  fl_nm_1L_chr,
  consent_1L_chr = "",
  rmds_dir_1L_chr = "R/RMD Templates",
  consent_indcs_int = 1L,
  options_chr = c("Y", "N"),
  return_1L_lgl = FALSE
)
}
\arguments{
\item{dir_path_1L_chr}{Directory path (a character vector of length one)}

\item{fl_nm_1L_chr}{File name (a character vector of length one)}

\item{consent_1L_chr}{Consent (a character vector of length one), Default: ''}

\item{rmds_dir_1L_chr}{R Markdowns directory (a character vector of length one), Default: 'R/RMD Templates'}

\item{consent_indcs_int}{Consent indices (an integer vector), Default: 1}

\item{options_chr}{Options (a character vector), Default: c("Y", "N")}

\item{return_1L_lgl}{Return (a logical vector of length one), Default: FALSE}
}
\value{
No return value, called for side effects.
}
\description{
write_to_copy_rmds() is used to copy template RMD or Rmarkdown files to specified sub-directories of a model documentation website. These template copies can then be manually edited before being rendered with write_to_render_post().
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  write_to_copy_rmds(dir_path_1L_chr = tempdir(),
                     fl_nm_1L_chr = "RMDs",
                     rmds_dir_1L_chr = system.file("MD_RMDs",
                                                   package = "ready4"))
\dontshow{\}) # examplesIf}
}
