% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_sqlite}
\alias{write_rcdf_sqlite}
\title{Write RCDF data to a SQLite database}
\usage{
write_rcdf_sqlite(data, path, db_name = "cbms_data", ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{Output directory for the database file.}

\item{db_name}{Name of the SQLite database file (without extension).}

\item{...}{Additional arguments passed to \code{DBI::dbWriteTable()}.}

\item{parent_dir}{Optional subdirectory under `path` to store the SQLite file.}
}
\value{
Invisibly returns \code{NULL}. A \code{.db} file is written to disk.
}
\description{
Writes all tables in the RCDF object to a single SQLite database file.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_sqlite(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
