% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{as_draws}
\alias{as_draws}
\title{Creates a \code{draws} object}
\usage{
as_draws(method, samples, data, formula, n_failures = NULL, fit = NULL)
}
\arguments{
\item{method}{A \code{method} object as generated by either \code{\link[=method_bayes]{method_bayes()}},
\code{\link[=method_approxbayes]{method_approxbayes()}}, \code{\link[=method_condmean]{method_condmean()}} or \code{\link[=method_bmlmi]{method_bmlmi()}}.}

\item{samples}{A list of \code{sample_single} objects. See \code{\link[=sample_single]{sample_single()}}.}

\item{data}{R6 \code{longdata} object containing all relevant input data information.}

\item{formula}{Fixed effects formula object used for the model specification.}

\item{n_failures}{Absolute number of failures of the model fit.}

\item{fit}{If \code{method_bayes()} is chosen, returns the MCMC Stan fit object. Otherwise \code{NULL}.}
}
\value{
A \code{draws} object which is a named list containing the following:
\itemize{
\item \code{data}: R6 \code{longdata} object containing all relevant input data information.
\item \code{method}: A \code{method} object as generated by either \code{\link[=method_bayes]{method_bayes()}},
\code{\link[=method_approxbayes]{method_approxbayes()}} or \code{\link[=method_condmean]{method_condmean()}}.
\item \code{samples}: list containing the estimated parameters of interest.
Each element of \code{samples} is a named list containing the following:
\itemize{
\item \code{ids}: vector of characters containing the ids of the subjects included in the original dataset.
\item \code{beta}: numeric vector of estimated regression coefficients.
\item \code{sigma}: list of estimated covariance matrices (one for each level of \code{vars$group}).
\item \code{theta}: numeric vector of transformed covariances.
\item \code{failed}: Logical. \code{TRUE} if the model fit failed.
\item \code{ids_samp}: vector of characters containing the ids of the subjects included in the given sample.
}
\item \code{fit}: if \code{method_bayes()} is chosen, returns the MCMC Stan fit object. Otherwise \code{NULL}.
\item \code{n_failures}: absolute number of failures of the model fit.
Relevant only for \code{method_condmean(type = "bootstrap")}, \code{method_approxbayes()} and \code{method_bmlmi()}.
\item \code{formula}: fixed effects formula object used for the model specification.
}
}
\description{
Creates a \code{draws} object which is the final output of a call to \code{\link[=draws]{draws()}}.
}
