% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zstd_file_functions.R
\name{zstd_decompress_file}
\alias{zstd_decompress_file}
\title{Zstd file decompression}
\usage{
zstd_decompress_file(input_file, output_file)
}
\arguments{
\item{input_file}{Path to the zstd file.}

\item{output_file}{Path for the decompressed file.}
}
\value{
No value is returned. The file is written to disk.
}
\description{
A utility function to decompresses a zstd file to disk.
}
\examples{
infile <- tempfile()
writeBin(as.raw(1:5), infile)
zfile <- tempfile()
zstd_compress_file(infile, zfile, compress_level = 1)
outfile <- tempfile()
zstd_decompress_file(zfile, outfile)
stopifnot(identical(readBin(infile, what = "raw", n = 5), readBin(outfile, what = "raw", n = 5)))
}
