% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{convert_numeric}
\alias{convert_numeric}
\alias{is_numeric}
\title{Check and Convert to Numeric}
\usage{
is_numeric(variable)

convert_numeric(data_frame, variables)
}
\arguments{
\item{variable}{A vector with values to check.}

\item{data_frame}{A data frame containing variables to convert.}

\item{variables}{Variables from the data frame which should be converted
to numeric.}
}
\value{
\code{\link[=is_numeric]{is_numeric()}} returns TRUE if all none NA values are numerical, otherwise FALSE.

\code{\link[=convert_numeric]{convert_numeric()}} returns the same data frame with converted variables where possible.
}
\description{
\code{\link[=is_numeric]{is_numeric()}} checks whether all values of the given variable, that are not
NA, are numerical.

\code{\link[=convert_numeric]{convert_numeric()}} converts all given variables to numeric if possible. If
a variable contains none numerical values (not including NAs), the variable
will not be converted.
}
\examples{
# Check if vectors contain only numeric values
test_vector1 <- c(1, 2, 3, NA, 4, 5)
test_vector2 <- c(1, 2, "Hello", NA, 4, 5)

numeric_check1 <- is_numeric(test_vector1)
numeric_check2 <- is_numeric(test_vector2)

# Convert variables in a data frame to numeric where possible
test_df <- data.frame(var_a = c(1, 2, 3, NA, 4, 5),
                      var_b = c(1, 2, "Hello", NA, 4, 5))

convert_df <- test_df |> convert_numeric(c("var_a", "var_b"))

}
