% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lme_model.R
\name{lme_model}
\alias{lme_model}
\title{Linear Mixed Effect Model}
\usage{
lme_model(
  data,
  model = NULL,
  response_variable,
  random_effect_factors = NULL,
  non_random_effect_factors = NULL,
  two_way_interaction_factor = NULL,
  three_way_interaction_factor = NULL,
  id,
  estimation_method = "REML",
  opt_control = "bobyqa",
  na.action = stats::na.omit,
  use_package = "lmerTest",
  quite = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{model}{\code{lme4} model syntax. Support more complicated model. Note that model_summary will only return fixed effect estimates.}

\item{response_variable}{DV (i.e., outcome variable / response variable). Length of 1. Support \code{dplyr::select()} syntax.}

\item{random_effect_factors}{random effect factors (level-1 variable for HLM people) Factors that need to estimate fixed effect and random effect (i.e., random slope / varying slope based on the id). Support \code{dplyr::select()} syntax.}

\item{non_random_effect_factors}{non-random effect factors (level-2 variable for HLM people). Factors only need to estimate fixed effect. Support \code{dplyr::select()} syntax.}

\item{two_way_interaction_factor}{two-way interaction factors. You need to pass 2+ factor. Support \code{dplyr::select()} syntax.}

\item{three_way_interaction_factor}{three-way interaction factor. You need to pass exactly 3 factors. Specifying three-way interaction factors automatically included all two-way interactions, so please do not specify the two_way_interaction_factor argument. Support \code{dplyr::select()} syntax.}

\item{id}{the nesting variable (e.g. group, time). Length of 1. Support \code{dplyr::select()} syntax.}

\item{estimation_method}{character. \code{ML} or \code{REML} default to \code{REML}.}

\item{opt_control}{default is \code{optim} for \code{lme} and \code{bobyqa} for \code{lmerTest}}

\item{na.action}{default is \code{stats::na.omit}. Another common option is \code{na.exclude}}

\item{use_package}{Default is \code{lmerTest}. Only available for linear mixed effect model. Options are \code{nlme}, \code{lmerTest}, or \code{lme4}(\verb{'lme4} return similar result as \code{lmerTest} except the return model)}

\item{quite}{suppress printing output}
}
\value{
an object representing the linear mixed-effects model fit (it maybe an object from \code{lme} or \code{lmer} depending of the package you use)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
Fit a linear mixed effect model (i.e., hierarchical linear model, multilevel linear model) using the \code{nlme::lme()}  or the \code{lmerTest::lmer()} function.
Linear mixed effect model is used to explore the effect of continuous / categorical variables in predicting a normally distributed continuous variable.
}
\details{
Here is a little tip. If you are using generic selecting syntax (e.g., contains() or start_with()), you don't need to remove the response variable and the id from the factors. It will be automatically remove. For example, if you have x1:x9 as your factors. You want to regress x2:x8 on x1. Your probably pass something like response_variable = x1, random_effect_factors = c(contains('x'),-x1) to the function. However, you don't need to do that, you can just pass random_effect_factors = c(contains('x')) to the function since it will automatically remove the response variable from selection.
}
\examples{
# two-level model with level-1 and level-2 variable with random intercept and random slope
fit1 <- lme_model(
  data = popular,
  response_variable = popular,
  random_effect_factors = c(extrav, sex),
  non_random_effect_factors = texp,
  id = class
)


# added two-way interaction factor
fit2 <- lme_model(
  data = popular,
  response_variable = popular,
  random_effect_factors = c(extrav, sex),
  non_random_effect_factors = texp,
  two_way_interaction_factor = c(extrav, texp),
  id = class
)

# pass a explicit lme model (I don't why you want to do that, but you can)
lme_fit <- lme_model(
  model = "popular ~ extrav*texp + (1 + extrav | class)",
  data = popular
)
}
