% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_model_summary.R
\name{lm_model_summary}
\alias{lm_model_summary}
\title{Model Summary for Linear Regression}
\usage{
lm_model_summary(
  data,
  response_variable = NULL,
  predictor_variable = NULL,
  two_way_interaction_factor = NULL,
  three_way_interaction_factor = NULL,
  family = NULL,
  cateogrical_var = NULL,
  graph_label_name = NULL,
  model_summary = TRUE,
  interaction_plot = TRUE,
  y_lim = NULL,
  plot_color = FALSE,
  digits = 3,
  simple_slope = FALSE,
  assumption_plot = FALSE,
  quite = FALSE,
  streamline = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{response_variable}{DV (i.e., outcome variable / response variable). Length of 1. Support \code{dplyr::select()} syntax.}

\item{predictor_variable}{IV. Support \code{dplyr::select()} syntax.}

\item{two_way_interaction_factor}{two-way interaction factors. You need to pass 2+ factor. Support \code{dplyr::select()} syntax.}

\item{three_way_interaction_factor}{three-way interaction factor. You need to pass exactly 3 factors. Specifying three-way interaction factors automatically included all two-way interactions, so please do not specify the two_way_interaction_factor argument. Support \code{dplyr::select()} syntax.}

\item{family}{a GLM family. It will passed to the family argument in glm. See \code{?glm} for possible options. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{cateogrical_var}{list. Specify the upper bound and lower bound directly instead of using ± 1 SD from the mean. Passed in the form of \code{list(var_name1 = c(upper_bound1, lower_bound1),var_name2 = c(upper_bound2, lower_bound2))}}

\item{graph_label_name}{optional vector or function. vector of length 2 for two-way interaction graph. vector of length 3 for three-way interaction graph. Vector should be passed in the form of c(response_var, predict_var1, predict_var2, ...). Function should be passed as a switch function (see ?two_way_interaction_plot for an example)}

\item{model_summary}{print model summary. Required to be \code{TRUE} if you want \code{assumption_plot}.}

\item{interaction_plot}{generate the interaction plot. Default is \code{TRUE}}

\item{y_lim}{the plot's upper and lower limit for the y-axis. Length of 2. Example: \code{c(lower_limit, upper_limit)}}

\item{plot_color}{If it is set to \code{TRUE} (default is \code{FALSE}), the interaction plot will plot with color.}

\item{digits}{number of digits to round to}

\item{simple_slope}{Slope estimate at +1/-1 SD and the mean of the moderator. Uses \code{interactions::sim_slope()} in the background.}

\item{assumption_plot}{Generate an panel of plots that check major assumptions. It is usually recommended to inspect model assumption violation visually. In the background, it calls \code{performance::check_model()}}

\item{quite}{suppress printing output}

\item{streamline}{print streamlined output}

\item{return_result}{If it is set to \code{TRUE} (default is \code{FALSE}), it will return the \code{model}, \code{model_summary}, and \code{plot} (if the interaction term is included)}
}
\value{
a list of all requested items in the order of model, model_summary, interaction_plot, simple_slope
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
An integrated function for fitting a linear regression model.
}
\examples{
fit <- lm_model_summary(
  data = iris,
  response_variable = "Sepal.Length",
  predictor_variable = dplyr::everything(),
  two_way_interaction_factor = c(Sepal.Width, Species),
  interaction_plot = FALSE, # you can also request the interaction plot
  simple_slope = FALSE, # you can also request simple slope estimate 
  assumption_plot = FALSE, # you can also request assumption plot
  streamline = FALSE #you can change this to get the least amount of info
)
}
