% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta-binom-analytic.R
\name{min_n_beta_binom}
\alias{min_n_beta_binom}
\title{Minimum n for Target Assurance (Beta-Binomial)}
\usage{
min_n_beta_binom(
  gen_prior_mode,
  gen_prior_n,
  desired_power,
  aud_prior_mode = 0.5,
  aud_prior_n = 2,
  hdi_mass = 0.95,
  rope = NULL,
  hdi_max_width = NULL,
  n_start = 20,
  n_max = 1e+05,
  verbose = TRUE
)
}
\arguments{
\item{gen_prior_mode}{Generating prior mode in (0,1).}

\item{gen_prior_n}{Generating prior concentration (>= 2).}

\item{desired_power}{Target assurance value in (0,1).}

\item{aud_prior_mode}{Audience prior mode in (0,1).}

\item{aud_prior_n}{Audience prior concentration (>= 2).}

\item{hdi_mass}{HDI mass (e.g., 0.95).}

\item{rope}{Length-2 numeric vector for ROPE bounds, or NULL for max-width rule.}

\item{hdi_max_width}{Positive width threshold for the HDI (used if \code{rope=NULL}).}

\item{n_start}{Starting sample size for search.}

\item{n_max}{Maximum sample size to try.}

\item{verbose}{If TRUE, prints progress.}
}
\value{
Smallest n meeting the target assurance.
}
\description{
Minimum n for Target Assurance (Beta-Binomial)
}
