% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrderRelation.R
\name{OrderRelation}
\alias{OrderRelation}
\title{Extracting the order relation of a poset.}
\usage{
OrderRelation(poset)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}
}
\value{
A two-column matrix \eqn{M} of character strings (element \eqn{M[i,2]} dominates element \eqn{M[i,1]}).
}
\description{
Extracts the order relation from the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = dom)

M <- OrderRelation(pos)

}
