% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_simulations.R
\name{organizeSCRM}
\alias{organizeSCRM}
\title{Organize scrm output}
\usage{
organizeSCRM(seg_sites, nHap, nPops)
}
\arguments{
\item{seg_sites}{a matrix of segregating sites as produced by scrm. Each
column of the matrix is a different site and each row is a different
haplotype.}

\item{nHap}{an integer representing the total number of haplotypes simulated.}

\item{nPops}{an integer, representing the total number of populations of the
simulated model.}
}
\value{
a matrix of segregating sites, similar to \code{seg_sites} but with the
populations organized so that the order is always the same, regardless of
the model used.
}
\description{
This function is utilized to sort out the scrm output. The order of the
populations changes accordingly to the model used (i.e. single or parallel
origin). Running this function will re-organize the output produced by scrm,
so that the populations are in the same order in both models.
}
\keyword{internal}
