% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{rmd_filter}
\alias{rmd_filter}
\title{Robust Mahalanobis Distance (RMD) Filter Object}
\usage{
rmd_filter(omicsData, ignore_singleton_groups = TRUE, metrics = NULL)
}
\arguments{
\item{omicsData}{an object of the class 'pepData', 'proData', 'metabData',
'lipidData', or 'nmrData' created by \code{\link{as.pepData}},
\code{\link{as.proData}}, \code{\link{as.metabData}},
\code{\link{as.lipidData}}, or \code{\link{as.nmrData}}, respectively.}

\item{ignore_singleton_groups}{logical indicator of whether to remove
singleton groups or not; defaults to TRUE. A singleton group is a group
consisting of just a single sample. If TRUE, rmd_filter results are
returned only for samples in groups of size greater than 1. This is used
when calculating the correlation.}

\item{metrics}{A character vector indicating which metrics should be used
when calculating the robust Mahalanobis distance. This vector must contain
between two and five of the following options: "MAD" (Median Absolute
Deviation), "Kurtosis", "Skewness", "Correlation", and
"Proportion_Missing". The default is NULL. When NULL a combination of
metrics will be chosen depending on the class of omicsData.}
}
\value{
An S3 object of class 'rmdFilt' containing columns for the sample
  identifier, log2 robust Mahalanobis distance, p-values, and robust
  Mahalanobis distance
}
\description{
The method computes a robust Mahalanobis distance that can be mapped to a
p-value and used to identify outlying samples
}
\details{
The metrics on which the log2 robust Mahalanobis distance is based
 can be specified using the \code{metrics} argument. 
 \tabular{ll}{ pepData, proData \tab For pepData and proData objects, all 
 five of the metrics "MAD", "Kurtosis", "Skewness", "Correlation", 
 "Proportion_Missing" may be used (this is the default). \cr metabData, 
 lipidData, nmrData \tab The use of "Proportion_Missing" is discouraged due 
 to the general lack of missing data in these datasets (the default behavior 
 omits "Proportion_Missing" from the metrics). \cr }
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
mymetab <- edata_transform(omicsData = metab_object, data_scale = "log2")
mymetab <- group_designation(omicsData = mymetab, main_effects = "Phenotype")
rmd_results <- rmd_filter(omicsData = mymetab, 
                          metrics = c("MAD", "Skewness", "Correlation"))
rmd_results <- rmd_filter(omicsData = mymetab)

mypep <- edata_transform(omicsData = pep_object, data_scale = "log2")
mypep <- group_designation(omicsData = mypep, main_effects = "Phenotype")
rmd_results <- rmd_filter(omicsData = mypep)
\dontshow{\}) # examplesIf}
}
\references{
Matzke, M., Waters, K., Metz, T., Jacobs, J., Sims, A., Baric, 
 R., Pounds, J., and Webb-Robertson, B.J. (2011), \emph{Improved quality 
 control processing of peptide-centric LC-MS proteomics data}. 
 Bioinformatics. 27(20): 2866-2872.
}
\author{
Lisa Bramer, Kelly Stratton
}
