% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_polygon.R
\name{poly_pcv}
\alias{poly_pcv}
\title{Compute Perimeter Complexity Value (PCV)}
\usage{
poly_pcv(x, niter = 100)
}
\arguments{
\item{x}{A matrix or a list of matrices representing the coordinates of the
polygon(s).}

\item{niter}{An integer specifying the number of smoothing iterations. See
\code{\link[=poly_smooth]{poly_smooth()}} for more details.}
}
\value{
The PCV value(s) computed for the contour(s).

If \code{x} is a matrix, returns the complexity value of the polygon's
perimeter. If \code{x} is a list of matrices, returns a numeric vector of
complexity values for each polygon.
}
\description{
This function calculates the Perimeter Complexity Value (PCV) for a given set
of coordinates representing a contour. The PCV measures the variation of
distances between the original coordinates and the smoothed coordinates
relative to the perimeter length of the original contour. See more in
\code{details} section.
}
\details{
The PCV is computed using the following formula: \deqn{PCV =
\frac{sum(dists) \times sd(dists)}{perim}} where \eqn{dists}
represents the distances between corresponding points in the original and
smoothed coordinates, and \eqn{perim} is the perimeter length of the smoothed
contour.

The PCV is computed by first smoothing the input contour using a specified
number of iterations. The smoothed contour is then used to compute the
distances between corresponding points in the original and smoothed
coordinates. These distances reflect the variations in the contour shape
after smoothing. The sum of these distances represents the overall magnitude
of the variations. Next, the sum of distances is multiplied by the standard
deviation of the distances to capture the dispersion or spread of the
variations. Finally, this value is divided by the perimeter length of the
original contour to provide a relative measure of complexity. Therefore, the
PCV provides a relative measure of complexity by considering both the
magnitude and spread of the variations in the contour shape after smoothing.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
set.seed(20)
shp <- efourier_shape(npoints = 1000)
poly_pcv(shp)

# increase the complexity of the outline
shp2 <- poly_jitter(shp, noise_x = 20, noise_y = 250, plot = TRUE)

smo <- poly_smooth(shp2, niter = 100, plot = FALSE)
plot_contour(smo, col = "red")
poly_pcv(shp2)
}

}
