% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{image_shp}
\alias{image_shp}
\title{Construct a shape file from an image}
\usage{
image_shp(
  img,
  nrow = 1,
  ncol = 1,
  buffer_x = 0,
  buffer_y = 0,
  interactive = FALSE,
  viewer = get_pliman_viewer(),
  col_line = "red",
  size_line = 2,
  col_text = "red",
  size_text = 1,
  plot = TRUE
)
}
\arguments{
\item{img}{An object of class \code{Image}}

\item{nrow}{The number of desired rows in the grid. Defaults to \code{1}.}

\item{ncol}{The number of desired columns in the grid. Defaults to \code{1}.}

\item{buffer_x, buffer_y}{Buffering factor for the width and height,
respectively, of each individual shape's side. A value between 0 and 0.5 where 0
means no buffering and 0.5 means complete buffering (default: 0). A value of
0.25 will buffer the shape by 25\% on each side.}

\item{interactive}{If \code{FALSE} (default) the grid is created automatically
based on the image dimension and number of rows/columns. If \code{interactive = TRUE}, users must draw points at the diagonal of the desired bounding box
that will contain the grid.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are \code{"base"} and
\code{"mapview"}. If set to "base", the base R graphics system is used for
interactive plotting. If set to "mapview", the mapview package is used. To
set this argument globally for all functions in the package, you can use
the \code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{col_line, col_text}{The color of the line/text in the grid. Defaults to
\code{"red"}.}

\item{size_line, size_text}{The size of the line/text in the grid. Defaults to
\code{2.5}.}

\item{plot}{Plots the grid on the image? Defaults to \code{TRUE}.}
}
\value{
A list with \code{row * col} objects containing the plot coordinates.
}
\description{
Creates a list of object coordinates given the desired number of nrow and
columns. It starts by selecting 4 points at the corners of objects of
interest in the plot space. Then, given \code{nrow} and \code{ncol}, a grid is drawn
and the objects' coordinates are returned.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
flax <- image_pliman("flax_leaves.jpg")
shape <- image_shp(flax, nrow = 3, ncol = 5)
}

}
