% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_week_2d.R
\name{stat_week_2d}
\alias{stat_week_2d}
\title{Calculate week bins with additional binning in the y axis}
\usage{
stat_week_2d(
  mapping = NULL,
  data = NULL,
  geom = "tile",
  position = "identity",
  ...,
  bins.y = NULL,
  binwidth.y = NULL,
  breaks.y = NULL,
  center.y = NULL,
  boundary.y = NULL,
  closed.y = c("left", "right"),
  drop = TRUE,
  week_start = getOption("phylepic.week_start"),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, ...}{See \link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d}.}

\item{bins.y, binwidth.y, breaks.y, center.y, boundary.y, closed.y}{See the analogous parameters in \link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d}.}

\item{drop}{drop bins with zero count.}

\item{week_start}{Day the week begins (defaults to Monday).
Can be specified as a case-insensitive English weekday name such as "Monday"
or an integer. Since you generally won't want to mix definitions, it is
more convenient to control this globally with the \code{"phylepic.week_start"}
option, e.g. \code{options(phylepic.week_start = "Monday")}.}
}
\value{
ggplot2 stat layer.
}
\description{
Computes week bins for date data in the x aesthetic, and allows
the binning to be specified for the y aesthetic. This is mostly equivalent to
\code{\link[ggplot2:geom_bin_2d]{ggplot2::stat_bin_2d()}} with the x aesthetic handling fixed to weeks.
}
\details{
The computed aesthetics are similar to those of \code{stat_bin_2d()}, including
\code{after_stat(count)}, \code{after_stat(density)}, and the bin positions and sizes:
\code{after_stat(xmin)}, \code{after_stat(height)}, and so on.
}
\examples{
library(ggplot2)

set.seed(1)
events <- rep(as.Date("2024-01-31") - 0:30, rpois(31, 6))
values <- round(rgamma(length(events), 1, 0.01))
df <- data.frame(date = events, value = values)

ggplot(df) + stat_week_2d(aes(date, value), week_start = "Monday")
}
