% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.solar.spectra.data.r
\docType{data}
\name{sun_may_morning.spct}
\alias{sun_may_morning.spct}
\title{Ground level solar spectral irradiance (measured)}
\format{
A \code{source_spct} object with 1421 rows (250 nm to 899 nm,
  variable step) and 2 variables.
}
\usage{
sun_may_morning.spct
}
\description{
Datasets containing the wavelengths at a 0.5 nm to 1.0 nm interval and 
tabulated values of measured spectral irradiance for the sun.
}
\details{
The variables are as follows: 
\itemize{ 
\item w.length numeric (nm) 
\item s.e.irrad numeric (W m-2 nm-1) }
}
\note{
Instrument used: Maya2000Pro scanning double monochromator 
  spectroradiometer with a Bentham cosine corrected input optics. Recently 
  calibrated at STUK. Date and time: 31 May 2013, 11:23 EEST. Place:
  University of Helsinki, Viikki Campus, Finland. Coordinates: 60.226183 N,
  25.018302 E. Measurements done by Pedro J. Aphalo. Calibration and
  corrections done with package MayaCalc using bracketing and noise reduction
  (with filter measurement) and method "sun". Algorithm and calibration data
  by Lasse Ylianttila (STUK, Helsinki, Finland).
}
\examples{
sun_may_morning.spct
wl_range(sun_may_morning.spct)
e_irrad(sun_may_morning.spct)

}
\references{
Ylianttila, L.; Visuri, R.; Huurto, L. & Jokela, K. (2005) 
  Evaluation of a single-monochromator diode array spectroradiometer for 
  sunbed UV-radiation measurements. Photochem Photobiol, 81, 333-341
}
\keyword{datasets}
