% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convex_hull.R
\name{in_convex_hull}
\alias{in_convex_hull}
\title{Check whether treated unit is in the convex hull of donors}
\usage{
in_convex_hull(X1, X0, ...)
}
\arguments{
\item{X1}{\verb{N_covars by 1 matrix} of treated unit covariates}

\item{X0}{\verb{N_covars by N_donors matrix} of donor unit covariates}

\item{...}{additional arguments passed to \code{\link[clarabel:clarabel]{clarabel::clarabel()}}}
}
\value{
\code{bool} whether the treated unit is in the convex hull of
the donor units. \code{NA} if this cannot be determined. Vector if X1
has multiple columns.
}
\description{
This function finds out if the treated unit is in the convex hull
of the donor units.
}
\details{
This function does not actually construct the convex hull (which
is infeasible in higher dimensions), but rather it checks whether
the following linear program has a feasible solution:

min q'w s.t. Aw = b

with w constrained to be above 0 and sum to 1, the feasibility
of this linear program directly corresponds to whether the treated
is in the convex hull

When the treated unit very close to the boundary of the convex hull
this method usually cannot determine this exactly and this function
may return \code{NA} with the warning "Solver terminated due to lack of
progress"
}
\examples{
# create some data
set.seed(45)
X0 <- matrix(runif(20), nrow = 2)
X1 <- matrix(c(.5, .5))

# test if X1 is in the convex hull:
in_convex_hull(X1, X0)

# also works with multiple units in X1:
X1 <- cbind(X1, c(1.3, -3))
in_convex_hull(X1, X0)
}
